/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.glyph;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.glyph.EffectMark;
import com.github.jarva.arsadditions.common.item.UnstableReliquary;
import com.github.jarva.arsadditions.common.item.data.mark.MarkData;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonGlyphNames;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodRecall
extends AbstractCastMethod {
    public static MethodRecall INSTANCE = new MethodRecall();

    private MethodRecall() {
        super(ArsAdditions.prefix(AddonGlyphNames.MethodRecall), "Recall");
    }

    public String getBookDescription() {
        return "Recalls the target stored in a Reliquary and casts the spell on it.";
    }

    public CastResolveType onCast(@Nullable ItemStack stack, LivingEntity playerEntity, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        return this.cast(context, playerEntity, resolver);
    }

    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Player player = context.getPlayer();
        if (player == null) {
            return CastResolveType.FAILURE;
        }
        return this.cast(spellContext, (LivingEntity)player, resolver);
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return this.cast(spellContext, caster, resolver);
    }

    public CastResolveType onCastOnEntity(@Nullable ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return this.cast(spellContext, caster, resolver);
    }

    public CastResolveType cast(SpellContext context, LivingEntity caster, SpellResolver resolver) {
        ItemStack reliquary = UnstableReliquary.getReliquaryFromCaster(context, caster);
        if (reliquary == null) {
            return CastResolveType.FAILURE;
        }
        Level level = caster.level();
        if (!(level instanceof ServerLevel)) {
            return CastResolveType.FAILURE;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MarkData mark = (MarkData)reliquary.get(AddonDataComponentRegistry.MARK_DATA);
        if (mark == null) {
            return CastResolveType.FAILURE;
        }
        return mark.cast(context, reliquary, serverLevel, caster, resolver);
    }

    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        defaults.add(EffectMark.INSTANCE.getRegistryName());
    }

    protected int getDefaultManaCost() {
        return 50;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }
}

